/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.fabric.networking_api;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import org.sinytra.fabric.networking_api.server.NeoServerPlayNetworking;

@Mod(value="fabric_networking_api_v1")
public class NetworkingEventHooks {
    public NetworkingEventHooks(IEventBus bus) {
        bus.addListener(NetworkingEventHooks::onConfiguration);
        NeoForge.EVENT_BUS.addListener(NetworkingEventHooks::registerCommands);
        NeoForge.EVENT_BUS.addListener(NetworkingEventHooks::onPlayerReady);
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            return;
        }
        if (FMLLoader.getCurrent().isProduction()) {
            return;
        }
        DebugConfigCommand.register((CommandDispatcher)event.getDispatcher(), (CommandBuildContext)event.getBuildContext());
    }

    private static void onPlayerReady(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            NeoServerPlayNetworking.onClientReady(event.getPlayer());
        }
    }

    private static void onConfiguration(RegisterConfigurationTasksEvent event) {
        ServerConfigurationPacketListenerImpl listener = (ServerConfigurationPacketListenerImpl)event.getListener();
        ((ServerConfigurationConnectionEvents.Configure)ServerConfigurationConnectionEvents.CONFIGURE.invoker()).onSendConfiguration(listener, listener.server);
    }
}

